package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.admin.dto.UserCalViewDTO;
import gov.va.med.mhv.admin.model.UserCalView;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class UserCalViewConverter implements Converter<UserCalView, UserCalViewDTO> {
	@Override
	public UserCalViewDTO convert(UserCalView source) {
		UserCalViewDTO target = new UserCalViewDTO();

		target.setUserCalViewId(source.getUserCalViewId());
		target.setPreferredView(source.getPreferredView());
		target.setVhaReminders(source.getVhaReminders());
		target.setPersonalEventFilter(source.getPersonalEventFilter());
		target.setZipCode(source.getZipCode());
		target.setUserProfileId(source.getUserProfileId());

		if (source.getVisn() != null) {
			target.setVisn(new VisnConverter().convert(source.getVisn()));
		}

		return target;
	}

	public UserCalView convert(UserCalViewDTO source) {
		UserCalView target = new UserCalView();
		target.setUserCalViewId(source.getUserCalViewId());
		target.setPreferredView(source.getPreferredView());
		target.setVhaReminders(source.getVhaReminders());
		target.setPersonalEventFilter(source.getPersonalEventFilter());
		target.setZipCode(source.getZipCode());
		target.setUserProfileId(source.getUserProfileId());
		target.setOplock(0);

		if (source.getVisn() != null) {
			target.setVisn(new VisnConverter().convert(source.getVisn()));
		}

		return target;
	}

	public List<UserCalViewDTO> convert(List<UserCalView> source) {
		List<UserCalViewDTO> userCalViewDto = null;
		if (null != source) {
			userCalViewDto = new ArrayList<UserCalViewDTO>();

			for (UserCalView userCalView : source) {
				userCalViewDto.add(this.convert(userCalView));
			}

		}

		return userCalViewDto;
	}

}
